import { View, ScrollView, Animated } from "react-native";
import React, { useState, useEffect } from "react";
import { productDetailsStyle } from "./ProductDetailsStyle";
import BackNavigation from "../../../Utilities/CustomHeader/BackNavigation";
import ItemCarousel from "./ItemCarousel/ItemCarousel";
import ItemDetails from "./ItemDetails/ItemDetails";
import RatingAndReviews from "../ProductDetails/RatingAndReviews/RatingAndReviews";
import ItemOwner from "./ItemOwner/ItemOwner";
import { EditProfileStyle } from "../../../Profile/EditProfile/StyleEditProfile";
import dpr from "../../../Utilities/CustomStyleAttribute/dpr";
import RelatedItem from "./RelatedItem/RelatedItem";
import ShareNwishlist from "./ShareNwishlist/ShareNwishlist";
import { useDispatch, useSelector } from "react-redux";

import ProductDetailsSkeleton from "../../../../src/skeletons/screens/home/ProductDetailsSkeleton";
import ItemDescription from "./ItemDescription/ItemDescription";
import DeliveryOptions from "./DeliveryOptions/DeliveryOptions";
import {
    storeItemInCart,
    storeItemInCartDataProcess,
} from "../../../../redux/slices/cart/storeItemInCart";
import useAuth from "../../../../hooks/useAuth";
import { query } from "../../../../redux/slices/util/apiRequest";
import { getCartProduct } from "../../../../redux/slices/cart/getCartProducts";
import { mutationResponse } from "../../../../redux/slices/util/processResponse.js";
import {
    isWishlist,
    storeTempWishlist,
} from "../../../../redux/slices/user/myWishlist/getMyWishlist";
import SimpleNvariable from "./Footer/SimpleNvariable";
import Affiliate from "./Footer/Affiliate";
import AddToCartBtn from "./Footer/AddToCartBtn";
import useCustomToast from "../../../../hooks/useCustomToast";

import Toast from "react-native-toast-message";
import { getMyAddress } from "../../../../redux/slices/user/address/getMyAddress";
import { resetVariation } from "../../../../redux/slices/featureProducts/items/itemVariations";
import { useIsFocused, useNavigation } from "@react-navigation/native";

import { BASE_API_URL_STG } from "@env";
import { useRef } from "react";
import {
    closeModal,
    modalHeight,
    openModal,
} from "../../../../src/components/CustomModal/modalHelper";
import useLangTranslation from "../../../../hooks/useLangTranslation";
import { compareWithTodaysDate } from "../../../../helper/compareWithTodaysDate";
import { useNumberFormat } from "../../../../helper/numberFormat";
import useProcessPrice from "../../../../hooks/useProcessPrice";
import { getPreferences } from "../../../../redux/slices/preferences/getPreferences";
import ItemHeader from "./ItemDetails/ItemSection/ItemHeader";
import EmptyContent from "../../../Utilities/EmptyContent/EmptyContent";
import NoWishlistIcon from "../../../../assets/svgs/empty content/noWishlist.svg";

const ProductDetails = (props) => {
    const { trans } = useLangTranslation();
    const { route: { params: { slug, item } = {} } = {} } = props;
    const {
        name,
        categories = [null],
        featured_image, 
        isOutOfStock,
        featured,
        offerCheck,
        discountPercent,
        review_average = "" 
    } = item || {};
    const showToast = useCustomToast();
    const isFocused = useIsFocused();
    const { tempWishlistId, wishlist } = useSelector(
        (state) => state.getMyWishlistSlice
    );
    const { cartLoading } = useSelector((state) => state.storeItemInCartSlice);

    const productDetailsUrl = `${BASE_API_URL_STG}/user/product/${slug}`;
    const storeItemInCartUrl = `${BASE_API_URL_STG}/user/cart/store`;

    const dispatch = useDispatch();
    const navigation = useNavigation();
    const { access_token, user } = useAuth();
    const routeName = props?.route?.name;

    const [quantity, setQuantity] = useState(1);
    const [price, setPrice] = useState({
        regularPrice: null,
        salePrice: null,
    });
    const [inputData, setInputData] = useState({
        code: null,
    });
    const [loading, setLoading] = useState(true);

    const [productDetails, setProductDetails] = useState({});
    const [disableBtn, setDisableBtn] = useState(true);
    const [selectedDimensions, setSelectedDimensions] = useState({
        width: "",
        height: "",
        length: "",
    });

    const [itemCarouselData, setItemCarouselData] = useState({
        images: [featured_image],
        activeImage: 0,
    });
    const [itemBadge, setItemBadge] = useState({
        isOutOfStock,
        featured,
        offerCheck,
        discountPercent,
        review_average
    })
    const [itemHeaderData, setItemHeaderData] = useState({
        name,
        categories,
        reviews_allowed: 1,
        review_average
    })

    const {
        id,
        code,
        type,
        reviews_allowed,
        vendor_id,
        shop_alias,
        related_ids,
        is_wishlisted,
        wishlist_id,
        regular_price_formatted,
        sale_price_formatted,
        external_products,
        meta,
        share_link,
        sale_from,
        sale_to,
        variations
    } = productDetails?.data || {};
    let isSaleAvailable = compareWithTodaysDate(sale_from, sale_to);

    const [stockManage, setStockManage] = useState(null);

    useEffect(() => {
        let isMounted = true;
        (async () => {
            if (isMounted) {
                await dispatch(getPreferences());
                const singleItem = await query(
                    productDetailsUrl,
                    "GET",
                    access_token
                );
                const {status} = singleItem?.response || {};
                setProductDetails(singleItem);
                if (isMounted && singleItem?.data?.id) {
                    setItemCarouselData({
                        ...itemCarouselData,
                        images: singleItem?.data?.images,
                    });
                    setItemBadge({
                        isOutOfStock: singleItem?.data.isOutOfStock,
                        featured: singleItem?.data.featured,
                        offerCheck: singleItem?.data.offerCheck,
                        discountPercent: singleItem?.data.discountPercent,
                        review_average: singleItem?.data.review_average
                    })
                    setItemHeaderData({
                        name: singleItem?.data?.name,
                        categories: singleItem?.data?.categories,
                        reviews_allowed: singleItem?.data?.reviews_allowed,
                        review_average: singleItem?.data?.review_average
                    })
                    setStockManage({
                        stock_status: singleItem?.data?.stock_status,
                        stock_quantity: singleItem?.data?.stock_quantity,
                        manage_stocks: singleItem?.data?.manage_stocks,
                        backorders: singleItem?.data?.backorders,
                        criticalStockQuantity:
                            singleItem?.data?.critical_stock_quantity,
                    });
                } else if(status?.code == 503) {
                    setLoading(false);
                    showToast({
                        text1: trans(status?.message),
                        type: 'common',
                        position: 'bottom',
                        props: { variant: 'error' }
                    });
                } else {
                    setLoading(false);
                    showToast({
                        text1: trans("Something wrong, Please try again!"),
                        type: 'common',
                        position: 'bottom',
                        props: { variant: 'error' }
                    });
                }
            }
        })();
        return () => {
            isMounted = false;
        };
    }, [wishlist]);

    useEffect(() => {
        if (type == "Simple Product") {
            SP(stockManage?.manage_stocks);
        }
        function SP(manage_stocks) {
            if (manage_stocks) {
                if (stockManage?.backorders == 0) {
                    if (stockManage?.stock_quantity > 0) {
                        setDisableBtn(false);
                    } else if (stockManage?.stock_quantity <= 0) {
                        setDisableBtn(true);
                    }
                } else if (stockManage?.backorders == 1) {
                    setDisableBtn(false);
                }
            } else {
                if (
                    stockManage?.stock_status?.toLowerCase() == "out of stock"
                ) {
                    setDisableBtn(true);
                } else {
                    setDisableBtn(false);
                }
            }
        }
    }, [
        id,
        stockManage?.stock_quantity,
        stockManage?.stock_status,
    ]);

    useEffect(() => {
        dispatch(resetVariation());
    }, [id, isFocused]);

    const numberFormat = useNumberFormat();
    const processPrice = useProcessPrice();
    useEffect(() => {
        if (Object.keys(productDetails || {})?.length > 0) {
            if (type == "Variable Product") {
                let regularPrice = [];
                let salePrice = [];
                for (let item of variations) {
                    const {
                        regular_price_formatted,
                        sale_from,
                        sale_to,
                        sale_price_formatted,
                    } = item;
                    let rp = numberFormat(regular_price_formatted);
                    let sp = numberFormat(sale_price_formatted);
                    let isSaleAvailable = compareWithTodaysDate(
                        sale_from,
                        sale_to
                    );
                    regularPrice.push(rp);
                    if (sale_price_formatted && isSaleAvailable) {
                        salePrice.push(sp || rp);
                    }
                }

                setPrice({
                    regularPrice: `${processPrice(
                        Math.min(...regularPrice)
                    )} - ${processPrice(Math.max(...regularPrice))}`,
                    salePrice:
                        salePrice.length > 0
                            ? `${processPrice(
                                  Math.min(...salePrice)
                              )} - ${processPrice(Math.max(...salePrice))}`
                            : null,
                });
            } else {
                setPrice({
                    regularPrice: regular_price_formatted,
                    salePrice: isSaleAvailable && sale_price_formatted,
                });
            }
            if (type === "Simple Product" || type === "Grouped Product") {
                setInputData({
                    code: code,
                });
            }
            setLoading(false);
        }
    }, [id]);

    const handleAddToCart = async () => {
        let cartData;
        if (type == "Simple Product") {
            cartData = {
                ...inputData,
                qty: quantity,
            };
        }
        if (type === "Grouped Product" && (!inputData.group_products || inputData.group_products.length === 0)) {
            showToast({
                text1: trans("Failed to added to cart! please try again."),
                type: 'common',
                position: 'bottom',
                props: { variant: 'error' },
            });
            return;
        }
        if (type == "Grouped Product") {
            let formData = new FormData();
            formData.append("code", inputData.code);
            formData.append("is_group_product", inputData.is_group_product);
            formData.append(
                "group_products",
                JSON.stringify(inputData.group_products)
            );
            cartData = formData;
        }
        try {
            const res = await dispatch(
                storeItemInCart({ access_token, storeItemInCartUrl, cartData })
            );

            const { code, message } = storeItemInCartDataProcess(res?.payload);
            if (code == 200) {
                if (stockManage?.stock_quantity > 0) {
                    const qty =
                        stockManage.backorders == 1
                            ? Number(stockManage?.stock_quantity)
                            : Number(stockManage?.stock_quantity - quantity);

                    setStockManage({
                        ...stockManage,
                        stock_quantity: qty,
                        stock_status:
                            stockManage.backorders == 1 || qty > 0
                                ? trans("In Stock")
                                : trans("Out Of Stock"),
                    });
                }
                setQuantity(1);
            }
            showToast({
                text1: trans(message),
                text2: trans("Visit Cart"),
                type: "addToCart",
                position: "bottom",
                bottomOffset: 60,
                visibilityTime: 3000,
                props: {
                    func: () => {
                        props.navigation.navigate("my cart");
                        Toast.hide();
                    },
                },
            });

            const CARTURL = `${BASE_API_URL_STG}/user/carts`;
            dispatch(getCartProduct({ access_token, CARTURL }));
        } catch (error) {}
    };

    useEffect(() => {
        (async () => {
            let isMounted = true;
            if (isMounted) {
                await dispatch(getMyAddress(access_token));
            }
            return () => {
                isMounted = false;
            };
        })()
    }, []);

    useEffect(() => {
        (async () => {
            if (access_token && user && tempWishlistId) {
                const URL = `${BASE_API_URL_STG}/user/wishlist`;
                let formData = new FormData();
                formData.append("product_id", id);
                await mutationResponse(URL, "POST", formData, access_token);
                dispatch(isWishlist(!wishlist));
                dispatch(storeTempWishlist(null));
            }
        })()
    }, [user]);

    const [isVisible, setIsVisible] = useState(false);
    const modalY = useRef(new Animated.Value(modalHeight)).current;
    const onOpenModal = () => {
        openModal(setIsVisible, modalY);
    };
    const onCloseModal = () => {
        dispatch(resetVariation());
        closeModal(setIsVisible, modalY);
    };
    return (
        <>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={""}
                capitalize={false}
            />
            {
                !loading && Object.keys(productDetails || {}).length > 0 ? 
                <ShareNwishlist
                    productId={id}
                    routeName={routeName}
                    slug={slug}
                    name={name}
                    is_wishlisted={is_wishlisted}
                    shareLink={share_link}
                    wishlist_id={wishlist_id}
                />
                : null
            }
            <ScrollView style={productDetailsStyle.ScrollViewWrap}>
                <ItemCarousel
                    data={itemCarouselData}
                    productBadge={itemBadge}
                />
                <View style={productDetailsStyle.container}>
                    <ItemHeader data={itemHeaderData} />
                </View>
                {loading && <ProductDetailsSkeleton /> }
                {!loading && Object.keys(productDetails?.data ?? {})?.length == 0 && (
                    <View style={productDetailsStyle.container}>
                        <EmptyContent
                            Icon={NoWishlistIcon}
                            text={trans("No Data Found")}
                        />
                    </View>
                )}
                {!loading && Object.keys(productDetails?.data ?? {})?.length > 0 && (
					<>
						<ItemDetails
							price={price}
							productDetails={productDetails}
							stockManage={stockManage}
							disableBtn={disableBtn}
							setDisableBtn={setDisableBtn}
							inputData={inputData}
							setSelectedDimensions={setSelectedDimensions}
							setInputData={setInputData}
							images={itemCarouselData.images}
							isVisible={isVisible}
							modalY={modalY}
							onOpenModal={onOpenModal}
							onCloseModal={onCloseModal}
						/>
						<ItemDescription
							productDetails={productDetails}
							selectedDimensions={selectedDimensions}
						/>
						{type !== "Grouped Product" && (
							<DeliveryOptions productDetails={productDetails} />
						)}
						{reviews_allowed == 1 && (
							<RatingAndReviews
								productDetails={productDetails}
								setProductDetails={setProductDetails}
							/>
						)}
						{vendor_id && (
							<ItemOwner
								shop_alias={shop_alias}
								vendor_id={vendor_id}
								navigation={props.navigation}
							/>
						)}
						{related_ids?.length > 0 && (
							<View style={productDetailsStyle.relatedItemWrap}>
								<RelatedItem
									headerText={trans("Related Items")}
									related_ids={related_ids}
								/>
							</View>
						)}
					</>
				)}
            </ScrollView>
            {type == "Simple Product" && (
                <SimpleNvariable
                    meta={meta}
                    stockManage={stockManage}
                    disableBtn={disableBtn}
                    quantity={quantity}
                    setQuantity={setQuantity}
                    cartLoading={cartLoading}
                    handleAddToCart={handleAddToCart}
                />
            )}
            {type == "Variable Product" && (
                <View style={EditProfileStyle.changeInfo}>
                    <AddToCartBtn
                        disableBtn={false}
                        cartLoading={cartLoading}
                        handleAddToCart={onOpenModal}
                        width={dpr("wf") - dpr(24)}
                    />
                </View>
            )}
            {type == "External/Affiliate Product" && (
                <Affiliate external_products={external_products} />
            )}
            {type == "Grouped Product" && (
                <View style={EditProfileStyle.changeInfo}>
                    <AddToCartBtn
                        disableBtn={false}
                        cartLoading={cartLoading}
                        handleAddToCart={handleAddToCart}
                        width={dpr("wf") - dpr(24)}
                    />
                </View>
            )}
        </>
    );
};

export default ProductDetails;
